/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#include "ModuleManager.h"
#include "Conf.h"
#include _iDESCRIPTORLAYER_

ModuleManager::ModuleManager() {

    l = log::instance();
    hp = new HandlerPackager();
    mm = new ModuleMap();
    dl = new _iDESCRIPTORLAYER();

    int *boards, cant;
    boards = dl->getU4ABoards(cant);
    for (int i = 0 ; i < cant ; i++) {
        mm->add(buildModuleID(boards[i], U4AHND), boards[i], U4AHND, U4ADSC, U4ADSC);
    };
    delete [] boards;
}

ModuleManager::~ModuleManager() {

    l = NULL;
    delete hp;
    delete mm;
    delete dl;
}

bool ModuleManager::send(int id, char *data, int len, int timeout) {

    hndPackage *hpack;
    int dsc, nlen, hnd, serial;
    char *msg;
    bool ok = false;

    if (!mm->exists(id)) {
        return ok;
    }
    serial = mm->getSerial(id);
    hnd = mm->getHandler(id);

    hpack = new hndPackage();
    hpack->hnd = hnd;
    hpack->oper = SEND;
    for(int i=0; i<len ; i++) {
        hpack->data[i] = data[i];
    }
    msg = hp->buildPackage(hpack, len, nlen);
    delete hpack;

    dsc = mm->getEndpointSend(id);
    if (dsc == HNDERROR) {
        l->printLog("Error al pedir el descriptor de send del handler",true,true);
        delete [] msg;
        return ok;
    }
    else {
        ok = dl->send(serial, dsc, msg, nlen, timeout);
        delete [] msg;
        return ok;
    };
}

char * ModuleManager::receive(int id, bool& ok, int& len, int timeout) {

    char *msg, *res;
    int dsc, nlen, serial;
    hndPackage *hpack;

    if (!mm->exists(id)) {
        res = NULL;
        ok = false;
        return res;
    }
    dsc = mm->getEndpointRecv(id);
    if (dsc == HNDERROR) {
        res = NULL;
        ok = false;
        return res;
    }
    else {
        serial = mm->getSerial(id);
        msg = dl->receive(serial, dsc, nlen, ok, timeout);
        if (ok) {
            hpack = hp->unbuildPackage(msg, nlen);
            len = nlen-HEAD_HP_SIZE;
            res = new char[len];
            for (int i=0; i<len ; i++) {
                res[i] = hpack->data[i];
            }
            delete hpack;
            delete [] msg;
        }
        else {
            len = nlen;
            res = NULL;
        };
        return res;
    };
}

bool ModuleManager::configure(int id, char *conf, int len) {

    hndPackage *hpack;
    int dsc, nlen, hnd, serial;
    char *msg;
    bool ok = false;

    if (!mm->exists(id)) {
        return ok;
    }
    serial = mm->getSerial(id);
    hnd = mm->getHandler(id);

    hpack = new hndPackage();
    hpack->hnd = hnd;
    hpack->oper = CONFIG;
    for (int i=0; i<len ; i++) {
        hpack->data[i] = conf[i];
    }
    msg = hp->buildPackage(hpack, len, nlen);
    delete hpack;

    dsc = mm->getEndpointSend(id);
    if (dsc == HNDERROR) {
        l->printLog("Error al pedir el descriptor de send del handler",true,true);
        delete [] msg;
        return ok;
    }
    else {
        ok = dl->send(serial, dsc, msg, nlen, DELAYSEND);
        delete [] msg;
        return ok;
    };
}

int* ModuleManager::getU4ABoards(int& cant) {

    return (dl->getU4ABoards(cant));
}

int ModuleManager::requestEpIn(int serial, int dscin) {

    return (dl->requestDscIn(serial, dscin));
}

int ModuleManager::requestEpOut(int serial, int dscout) {

    return (dl->requestDscOut(serial, dscout));
}

void ModuleManager::registerModule(int id, int serial, int handler, int in, int out) {

    mm->add(id, serial, handler, in, out);
}

void ModuleManager::unregisterModule(int id) {

    int dsc, serial;

    serial = mm->getSerial(id);
    dsc = mm->getEndpointRecv(id);
    dl->freeDscIn(serial, dsc);
    dsc = mm->getEndpointSend(id);
    dl->freeDscOut(serial, dsc);
    mm->remove(id);
}

void ModuleManager::unregisterAllModules(int serial) {

    int id, cant;

    cant = mm->size();
    for (int i=cant-1; i >= 0; i--) {
        id = mm->getModuleID(i);
        if ((serial == mm->getSerial(id)) && (mm->getHandler(id) != U4AHND)) {
            dl->freeDscIn(serial, mm->getEndpointRecv(id));
            dl->freeDscOut(serial, mm->getEndpointSend(id));
            mm->remove(id);
        }
    }
}

bool ModuleManager::existsModule(int id) {

    return (mm->exists(id));
}

int ModuleManager::getSerialNumber(int id) {

    return (mm->getSerial(id));
}

int ModuleManager::getHandlerID(int id) {

    return (mm->getHandler(id));
}

int ModuleManager::buildModuleID(int serial, int dsc) {

    int board = dl->getInstanceBoard(serial);
    return ((board*MODULEID_GAP) + dsc);
}
